/*
 * Decompiled with CFR 0.152.
 */
package team.unnamed.mocha.runtime;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import team.unnamed.mocha.parser.ast.BinaryExpression;
import team.unnamed.mocha.parser.ast.CallExpression;
import team.unnamed.mocha.parser.ast.Expression;
import team.unnamed.mocha.parser.ast.ExpressionVisitor;
import team.unnamed.mocha.parser.ast.FloatExpression;
import team.unnamed.mocha.parser.ast.TernaryConditionalExpression;
import team.unnamed.mocha.runtime.ExpressionInterpreter;
import team.unnamed.mocha.runtime.IsConstantExpression;
import team.unnamed.mocha.runtime.Scope;

final class ExpressionInliner
implements ExpressionVisitor<Expression> {
    private final ExpressionInterpreter<?> interpreter;
    private final Scope scope;

    ExpressionInliner(@NotNull ExpressionInterpreter<?> interpreter, @NotNull Scope scope) {
        this.interpreter = Objects.requireNonNull(interpreter, "interpreter");
        this.scope = Objects.requireNonNull(scope, "scope");
    }

    @Override
    @NotNull
    public Expression visitBinary(@NotNull BinaryExpression expression) {
        if (IsConstantExpression.test(expression, this.scope)) {
            return FloatExpression.of(expression.visit(this.interpreter).getAsNumber());
        }
        return expression;
    }

    @Override
    @NotNull
    public Expression visitTernaryConditional(@NotNull TernaryConditionalExpression expression) {
        Expression conditionExpr = expression.condition();
        Expression trueExpr = expression.trueExpression();
        Expression falseExpr = expression.falseExpression();
        if (IsConstantExpression.test(conditionExpr, this.scope)) {
            boolean condition = conditionExpr.visit(this.interpreter).getAsBoolean();
            Expression resultExpr = condition ? trueExpr : falseExpr;
            return resultExpr.visit(this);
        }
        return expression;
    }

    @Override
    @NotNull
    public Expression visitCall(@NotNull CallExpression expression) {
        if (IsConstantExpression.test(expression, this.scope)) {
            return FloatExpression.of(expression.visit(this.interpreter).getAsNumber());
        }
        return expression;
    }

    @Override
    @NotNull
    public Expression visit(@NotNull Expression expression) {
        return expression;
    }
}

